; Script file for the JAWS for Windows application
; Copyright 1998 by Henter-Joyce, Inc.
; 4/23/98, A.Gonz.

Include "jfw.jsh"
Include "jfw.jsm"
Include "hjconst.jsh"
Include "hjglobal.jsh"

Script ScriptFileName ()
ScriptAndAppNames (msg0)
EndScript

Script ScreenSensitiveHelp ()
var
	handle hwnd,
	string theClass
if (GlobalMenuMode == 1) then
	ScreenSensitiveHelpForKnownClasses()  ;known types
	return
EndIf
let hwnd = GetCurrentWindow ()
let theClass = GetWindowClass (hwnd)
if ((theClass == wc_JAWS) ||
	((theClass == wc_EmptySpace) && (GetWindowClass (GetParent (hwnd)) == wc_JAWS))) then
	SayString (msg1);"This is the JAWS application window. "
	SayString (msg2 + ;"To toggle the keyboard help on or off press "
	GetScriptKeyName ("KeyBoardHelp") + ". ")
	SayString (msg3);"Use Alt to activate the menu bar"
	return
EndIf
PerformScript ScreenSensitiveHelp()
EndScript

Function FocusChangedEvent (handle FocusWindow, handle PrevWindow)
var
	handle RealWindow,
	string RealWindowName,
	handle AppWindow
let RealWindow = GetRealWindow (FocusWindow)
let RealWindowName = GetWindowName (RealWindow)
let AppWindow = GetAppMainWindow (FocusWindow)
if (GlobalPrevApp != AppWindow
	&& AppWindow != FocusWindow) then 
	; we've switched to a different app main window, 
	; and it does not have the focus, so announce it
	SayWindowTypeAndText (AppWindow)
endif
If ((GlobalPrevRealName != RealWindowName) ; name has changed
	|| (GlobalPrevReal != RealWindow)) then ; or handle has changed, then
	If (((RealWindow != AppWindow) || (GlobalPrevApp == AppWindow))
		&& (RealWindow != FocusWindow)) then
		SayWindowTypeAndText (RealWindow)
	endif
EndIf
let GlobalFocusWindow = FocusWindow
if (GlobalPrevFocus != focusWindow) then
	SayFocusedWindow () ; will use global variable GlobalFocusWindow
else
	SayFocusedObject ()
EndIf
;above perform will return here to finish this routine
;now set all the global variables for next time.
let GlobalPrevReal = RealWindow
let GlobalPrevRealName = RealWindowName
let GlobalPrevApp = AppWindow
let GlobalPrevFocus = FocusWindow
EndFunction